(function ($) {
	var WidgetRadiantProgressBarHandler = function ($scope) {
	    $('.rt-progressbar').each(function () {
				var elementPos = $(this).offset().top;
				var topOfWindow = $(window).scrollTop();
				var percent = $(this).find('.circle').attr('data-percent');
				var dcolor = $(this).find('.circle').attr('data-color');
				//var dcolor = 'red';
				var percentage = parseInt(percent, 10) / parseInt(100, 10);
				var animate = $(this).data('animate');
				if (elementPos < topOfWindow + $(window).height() - 30 && !animate) {
					$(this).data('animate', true);
					$(this).find('.circle').circleProgress({
						startAngle: -Math.PI / 2,
						value: percent / 100,
						size: 139,
						thickness: 10,
						emptyFill: "rgba(0,0,0, 0)",
						fill: {
							color: dcolor,
						}
					}).on('circle-animation-progress', function (event, progress, stepValue) {
						$(this).find('div').text((stepValue*100).toFixed(0) + "%");
					}).stop();
				}
			});
	    
	    
	    //alert(rtProgressbarContainer);
   // if(dom == null){
		var $rtProgressbarContainer = $scope.find(".rt-progressbar-container"),
			settings = $rtProgressbarContainer.data("settings"),
			length = settings.progress_length,
			speed = settings.speed;

		var $progressbar = $rtProgressbarContainer.find(".rt-progressbar-bar");

		$progressbar.animate({
			width: length
		}, speed);
		
    //}

	};

	var WidgetRadiantProgressBarScrollHandler = function ($scope, $) {
		elementorFrontend.waypoint($scope, function () {
			WidgetRadiantProgressBarHandler($(this));
		}, {
			offset: Waypoint.viewportHeight() - 150,
			triggerOnce: true
		});
	};

	$(window).on("elementor/frontend/init", function () {
		if (elementorFrontend.isEditMode()) {
			elementorFrontend.hooks.addAction(
				"frontend/element_ready/radiant-progressbar.default", WidgetRadiantProgressBarHandler);
		} else {
			elementorFrontend.hooks.addAction(
				"frontend/element_ready/radiant-progressbar.default", WidgetRadiantProgressBarScrollHandler);
		}
	});
})(jQuery);