<?php
/**
 * Includes Radiant Theme Addons elements like Blog,Team and Testimonials.
 *
 * @package RadiantThemes
 *
 * Plugin Name: Radiantthemes Addons
 * Description: Addon elements for Elementor Page Builder.
 * Plugin URI:  https://radiantthemes.com/
 * Version:     2.0
 * Author:      RadiantThemes
 * Author URI:  https://elementor.com/
 * Text Domain: radiantthemes-addons
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Main Radiantthemes Addons Class
 *
 * The init class that runs the Hello World plugin.
 * Intended To make sure that the plugin's minimum requirements are met.
 *
 * You should only modify the constants to match your plugin's needs.
 *
 * Any custom code should go inside Plugin Class in the plugin.php file.
 *
 * @since 1.0.0
 */
final class Radiantthemes_Addons {

	/**
	 * Plugin Version
	 *
	 * @since 1.0.0
	 * @var string The plugin version.
	 */
	const VERSION = '1.0.0';

	/**
	 * Minimum Elementor Version
	 *
	 * @since 1.0.0
	 * @var string Minimum Elementor version required to run the plugin.
	 */
	const MINIMUM_ELEMENTOR_VERSION = '2.0.0';

	/**
	 * Minimum PHP Version
	 *
	 * @since 1.0.0
	 * @var string Minimum PHP version required to run the plugin.
	 */
	const MINIMUM_PHP_VERSION = '5.6';

	/**
	 * Instance
	 *
	 * @since 1.0.0
	 *
	 * @access private
	 * @static
	 *
	 * @var Radiantthemes_Addons The single instance of the class.
	 */
	private static $_instance = null;

	/**
	 * Instance
	 *
	 * Ensures only one instance of the class is loaded or can be loaded.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 * @static
	 *
	 * @return Radiantthemes_Addons An instance of the class.
	 */
	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;

	}

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function __construct() {

		// Load translation.
		add_action( 'init', array( $this, 'i18n' ) );

		add_action( 'init', array( $this, 'radiantthemes_coming_soon_maintenance' ) );

		add_action( 'init', array( $this, 'is_login_page' ) );

		// Init Plugin.
		add_action( 'plugins_loaded', array( $this, 'init' ) );

		add_action( 'elementor/elements/categories_registered', array( $this, 'add_elementor_widget_categories' ) );
	}

	/**
	 * Load Textdomain
	 *
	 * Load plugin localization files.
	 * Fired by `init` action hook.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function i18n() {
		load_plugin_textdomain( 'radiantthemes-addons' );
	}

	/**
	 * Check Login Page
	 *
	 * @return boolean
	 */
	public function is_login_page() {
		if ( 0 === strncmp( $_SERVER['REQUEST_URI'], '/wp-login.php', strlen( '/wp-login.php' ) ) ) {
			return ! strncmp( $_SERVER['REQUEST_URI'], '/wp-login.php', strlen( '/wp-login.php' ) );
		}

		if ( 0 === strncmp( $_SERVER['REQUEST_URI'], '/wp-admin', strlen( '/wp-admin' ) ) ) {
			return ! strncmp( $_SERVER['REQUEST_URI'], '/wp-admin', strlen( '/wp-admin' ) );
		}
	}

	/**
	 * Coming Soon and Maintenance Mode.
	 *
	 * @return void
	 */
	public function radiantthemes_coming_soon_maintenance() {
		if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
			/**
			 * Load Roboto and Josefin Sans Google Font when redux framework is not installed.
			 */
		
			$rt_theme_option = get_option( 'softek_theme_option' );
			$rt_coming_soon  = $rt_theme_option['coming_soon_switch'];
			$rt_maintenance  = $rt_theme_option['maintenance_mode_switch'];
			if ( ! is_user_logged_in() && ! $this->is_login_page() && $rt_coming_soon ) {
			    //deactivate_plugins( '/acf-typography-field/acf-typography.php' );
			     
				include 'coming-soon.php';
				die;
			} elseif ( ! is_user_logged_in() && ! $this->is_login_page() && $rt_maintenance ) {
				include 'maintenance.php';
				die;
			} elseif ( ! is_user_logged_in() && ! $this->is_login_page() && $rt_coming_soon && $rt_maintenance ) {
				include 'coming-soon.php';
				die;
			}
			//else{activate_plugin('/acf-typography-field/acf-typography.php');}
		}
	}

	/**
	 * Initialize the plugin
	 *
	 * Validates that Elementor is already loaded.
	 * Checks for basic plugin requirements, if one check fail don't continue,
	 * if all check have passed include the plugin class.
	 *
	 * Fired by `plugins_loaded` action hook.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function init() {

		// Check if Elementor installed and activated.
		if ( ! did_action( 'elementor/loaded' ) ) {
			add_action( 'admin_notices', array( $this, 'admin_notice_missing_main_plugin' ) );
			return;
		}

		// Check for required Elementor version.
		if ( ! version_compare( ELEMENTOR_VERSION, self::MINIMUM_ELEMENTOR_VERSION, '>=' ) ) {
			add_action( 'admin_notices', array( $this, 'admin_notice_minimum_elementor_version' ) );
			return;
		}

		// Check for required PHP version.
		if ( version_compare( PHP_VERSION, self::MINIMUM_PHP_VERSION, '<' ) ) {
			add_action( 'admin_notices', array( $this, 'admin_notice_minimum_php_version' ) );
			return;
		}

		// Once we get here, We have passed all validation checks so we can safely include our plugin.
		require_once 'class-plugin.php';
	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have Elementor installed or activated.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function admin_notice_missing_main_plugin() {
		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor */
			esc_html__( '"%1$s" requires "%2$s" to be installed and activated.', 'radiantthemes-addons' ),
			'<strong>' . esc_html__( 'Radiantthemes Addons', 'radiantthemes-addons' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'radiantthemes-addons' ) . '</strong>'
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required Elementor version.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function admin_notice_minimum_elementor_version() {
		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}

		$message = sprintf(
			/* translators: 1: Plugin name 2: Elementor 3: Required Elementor version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'radiantthemes-addons' ),
			'<strong>' . esc_html__( 'Radiantthemes Addons', 'radiantthemes-addons' ) . '</strong>',
			'<strong>' . esc_html__( 'Elementor', 'radiantthemes-addons' ) . '</strong>',
			self::MINIMUM_ELEMENTOR_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
	}

	/**
	 * Admin notice
	 *
	 * Warning when the site doesn't have a minimum required PHP version.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	public function admin_notice_minimum_php_version() {
		if ( isset( $_GET['activate'] ) ) {
			unset( $_GET['activate'] );
		}

		$message = sprintf(
			/* translators: 1: Plugin name 2: PHP 3: Required PHP version */
			esc_html__( '"%1$s" requires "%2$s" version %3$s or greater.', 'radiantthemes-addons' ),
			'<strong>' . esc_html__( 'Radiantthemes Addons', 'radiantthemes-addons' ) . '</strong>',
			'<strong>' . esc_html__( 'PHP', 'radiantthemes-addons' ) . '</strong>',
			self::MINIMUM_PHP_VERSION
		);

		printf( '<div class="notice notice-warning is-dismissible"><p>%1$s</p></div>', $message );
	}

	/**
	 * Add Custom Elementor Categories
	 *
	 * @param [type] $elements_manager Category Names Array.
	 * @since 1.0.0
	 * @access public
	 */
	public function add_elementor_widget_categories( $elements_manager ) {

		$elements_manager->add_category(
			'radiant-widgets-category',
			array(
				'title' => __( 'Radiant Addons', 'plugin-name' ),
				'icon'  => 'fa fa-plug',
			)
		);

	}
}

// Instantiate Radiantthemes_Addons.
Radiantthemes_Addons::instance();

if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
	/**
	 * Add button radiaus custom css to wp_head().
	 */
	function button_radius_head_styles() {
		$rt_theme_option = get_option( 'softek_theme_option' );
		$buttonradius    = '';
		$buttonradius    = esc_html( radiantthemes_global_var( 'border-radius', 'margin-top', true ) );
		$buttonradius   .= ' ' . esc_html( radiantthemes_global_var( 'border-radius', 'margin-top', true ) );
		$buttonradius   .= ' ' . esc_html( radiantthemes_global_var( 'border-radius', 'margin-top', true ) );
		$buttonradius   .= ' ' . esc_html( radiantthemes_global_var( 'border-radius', 'margin-top', true ) );

		$buttonborderradius = '.radiantthemes-button > .radiantthemes-button-main, .gdpr-notice .btn, .shop_single > .summary form.cart .button, .shop_single #review_form #respond input[type="submit"], .woocommerce button.button[name="apply_coupon"], .woocommerce button.button[name="update_cart"], .woocommerce button.button[name="update_cart"]:disabled, .woocommerce-cart .wc-proceed-to-checkout a.checkout-button, .woocommerce form.checkout_coupon .form-row .button, .woocommerce #payment #place_order, .woocommerce .return-to-shop .button, .woocommerce form .form-row input.button, .woocommerce table.shop_table.wishlist_table > tbody > tr > td.product-add-to-cart a, .widget-area > .widget.widget_price_filter .button, .post.style-default .entry-main .entry-extra .entry-extra-item .post-read-more .btn span, .page.style-default .entry-main .entry-extra .entry-extra-item .post-read-more .btn span, .tribe_events.style-default .entry-main .entry-extra .entry-extra-item .post-read-more .btn span, .testimonial.style-default .entry-main .entry-extra .entry-extra-item .post-read-more .btn span, .team.style-default .entry-main .entry-extra .entry-extra-item .post-read-more .btn span, .portfolio.style-default .entry-main .entry-extra .entry-extra-item .post-read-more .btn span, .case-studies.style-default .entry-main .entry-extra .entry-extra-item .post-read-more .btn span, .client.style-default .entry-main .entry-extra .entry-extra-item .post-read-more .btn span, .product.style-default .entry-main .entry-extra .entry-extra-item .post-read-more .btn span, .comments-area .comment-form > p button[type="submit"], .comments-area .comment-form > p button[type="reset"], .wraper_error_main.style-one .error_main .btn, .wraper_error_main.style-two .error_main .btn, .wraper_error_main.style-three .error_main_item .btn, .wraper_error_main.style-four .error_main .btn, .btn {  border-radius:' . $buttonradius . ' !important ; }';

		if ( ! isset( $rt_theme_option['coming_soon_one_background']['background-repeat'] ) ) {
		    $rt_theme_option['coming_soon_one_background']['background-repeat'] = 'repeat';
		}
		
		$coming_soon_bg = '
		.wraper_comingsoon_main.style-one {
			background-color:' . $rt_theme_option['coming_soon_one_background']['background-color'] . ';
			background-repeat:' . $rt_theme_option['coming_soon_one_background']['background-repeat'] . ';
			background-size: ' . $rt_theme_option['coming_soon_one_background']['background-size'] . ';
			
			background-position:' . $rt_theme_option['coming_soon_one_background']['background-position'] . ';
			background-image: url(' . $rt_theme_option['coming_soon_one_background']['background-image'] . ');
		}';

		echo '<style  type="text/css">' . $buttonborderradius . $coming_soon_bg . '</style>';
	}
	add_action( 'wp_head', 'button_radius_head_styles' );
}

function radiantthemes_change_elementor_frontend_css() {
	// Bail if Elementor is not available.
	if ( ! defined( 'ELEMENTOR_VERSION' ) ) {
		return;
	}

	global $wp_styles;

	$path = $_SERVER['DOCUMENT_ROOT'] . parse_url( $wp_styles->registered['elementor-frontend']->src )['path'];
	$css  = file_get_contents( $path );
	$css  = str_replace( '.elementor-heading-title{padding:0;margin:0;line-height:1}', '.elementor-heading-title{padding:0;margin:0;}', $css, $count );

	if ( $count ) {
		file_put_contents( $path, $css );
	}
}
add_action( 'wp_enqueue_scripts', 'radiantthemes_change_elementor_frontend_css' );
