<?php
/**
 * Template for Coming Soon Page
 *
 * @package softek
 */

if ( $rt_theme_option['social-icon-target'] ) {
	$social_target = 'target="_blank"';
} else {
	$social_target = '';
}
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="format-detection" content="telephone=no">
	<?php wp_head(); ?>
</head>
<div id="primary" class="content-area">
	<main id="main" class="site-main" role="main">
		<!-- wraper_comingsoon_main -->
		<div class="wraper_comingsoon_main style-one">
			<!-- START OF 404 STYLE ONE CONTENT -->
			<div class="table">
				<div class="table-cell">
					<!-- comingsoon_main -->
					<div class="comingsoon_main">
						<div class="holder">
							<?php
							if ( $rt_theme_option['coming_soon_one_content'] ) {
								echo wp_kses_post( $rt_theme_option['coming_soon_one_content'] );
							}
							?>
						</div>
						<!-- comingsoon-counter -->
						<div class="comingsoon-counter" data-launch-date="<?php echo esc_attr( $rt_theme_option['coming_soon_datetime'] ); ?>">
						</div>
						<?php
						if ( $rt_theme_option['coming_soon_one_subscribe'] ) {
							echo do_shortcode( $rt_theme_option['coming_soon_one_subscribe'] );
						}
						?>
						<!-- comingsoon-counter -->
						<ul class="social">
							<?php if ( ! empty( $rt_theme_option['social-icon-googleplus'] ) ) : ?>
								<li class="google-plus"><a href="<?php echo esc_url( $rt_theme_option['social-icon-googleplus'] ); ?>" rel="publisher" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-google-plus"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-facebook'] ) ) : ?>
								<li class="facebook"><a href="<?php echo esc_url( $rt_theme_option['social-icon-facebook'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-facebook"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-twitter'] ) ) : ?>
								<li class="twitter"><a href="<?php echo esc_url( $rt_theme_option['social-icon-twitter'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-twitter"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-vimeo'] ) ) : ?>
								<li class="vimeo"><a href="<?php echo esc_url( $rt_theme_option['social-icon-vimeo'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-vimeo"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-youtube'] ) ) : ?>
								<li class="youtube"><a href="<?php echo esc_url( $rt_theme_option['social-icon-youtube'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-youtube-play"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-flickr'] ) ) : ?>
								<li class="flickr"><a href="<?php echo esc_url( $rt_theme_option['social-icon-flickr'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-flickr"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-linkedin'] ) ) : ?>
								<li class="linkedin"><a href="<?php echo esc_url( $rt_theme_option['social-icon-linkedin'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-linkedin"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-pinterest'] ) ) : ?>
								<li class="pinterest"><a href="<?php echo esc_url( $rt_theme_option['social-icon-pinterest'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-pinterest-p"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-xing'] ) ) : ?>
								<li class="xing"><a href="<?php echo esc_url( $rt_theme_option['social-icon-xing'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-xing"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-viadeo'] ) ) : ?>
								<li class="viadeo"><a href="<?php echo esc_url( $rt_theme_option['social-icon-viadeo'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-viadeo"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-vkontakte'] ) ) : ?>
								<li class="vkontakte"><a href="<?php echo esc_url( $rt_theme_option['social-icon-vkontakte'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-vk"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-tripadvisor'] ) ) : ?>
								<li class="tripadvisor"><a href="<?php echo esc_url( $rt_theme_option['social-icon-tripadvisor'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-tripadvisor"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-tumblr'] ) ) : ?>
								<li class="tumblr"><a href="<?php echo esc_url( $rt_theme_option['social-icon-tumblr'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-tumblr"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-behance'] ) ) : ?>
								<li class="behance"><a href="<?php echo esc_url( $rt_theme_option['social-icon-behance'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-behance"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-instagram'] ) ) : ?>
								<li class="instagram"><a href="<?php echo esc_url( $rt_theme_option['social-icon-instagram'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-instagram"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-dribbble'] ) ) : ?>
								<li class="dribbble"><a href="<?php echo esc_url( $rt_theme_option['social-icon-dribbble'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-dribbble"></i></a></li>
							<?php endif; ?>
							<?php if ( ! empty( $rt_theme_option['social-icon-skype'] ) ) : ?>
								<li class="skype"><a href="<?php echo esc_url( $rt_theme_option['social-icon-skype'] ); ?>" <?php echo esc_attr( $social_target ); ?>><i class="fa fa-skype"></i></a></li>
							<?php endif; ?>
						</ul>
					</div>
					<!-- comingsoon_main -->
				</div>
			</div>
			<!-- END OF 404 STYLE ONE CONTENT -->
		</div>
		<!-- wraper_comingsoon_main -->
	</main><!-- #main -->
</div><!-- #primary -->
<?php wp_footer(); ?>
</body>
</html>
