<?php
/**
 * Case Studies Addon
 *
 * @package Radiantthemes
 */

namespace RadiantthemesAddons\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor Blog widget.
 *
 * Elementor widget that displays posts in different styles.
 *
 * @since 1.0.0
 */
class Radiantthemes_style_Case_Studies extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'radiant-case_studies';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Case Studies', 'radiantthemes-addons' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-post-list';
	}

	/**
	 * Requires css files.
	 *
	 * @return array
	 */
	public function get_style_depends() {
		return [
			'radiantthemes-addons-custom',
		];
	}

	/**
	 * Requires js files.
	 *
	 * @return array
	 */
	// public function get_script_depends() {
	// return [
	// 'radiantthemes-blog',
	// ];
	// }

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'radiant-widgets-category' ];
	}

	/**
	 * Get all case Custom Post Type Categories.
	 *
	 * @return array case categories.
	 */
	public function get_case_categories() {
		$case_terms = get_terms(
			array(
				'taxonomy'   => 'case-study-category',
				'hide_empty' => false,
			)
		);

		$case_category_array = array();
		$case_category_array = array( 'all' => 'Show all' );
		if ( ! empty( $case_terms ) ) {
			foreach ( $case_terms as $case_term ) {
				$case_category_array[ $case_term->slug ] = $case_term->name;
			}
		}

		return $case_category_array;
	}


	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'radiantthemes-addons' ),
			]
		);

		$this->add_control(
			'case_study_style_variation',
			[
				'label'       => esc_html__( 'Case Study Style', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'options'     => [
					
					'one'   => esc_html__( 'Style One (Overlay SlideUp On Hover)', 'radiantthemes-addons' ),
					//'two'   => esc_html__( 'Style 2 (Overlay SlideUp On Hover)', 'radiantthemes-addons' ),
					//'three'   => esc_html__( 'Style 3 (Overlay SlideUp On Hover)', 'radiantthemes-addons' ),
					
				],
				'default'     => 'one',
			]
		);
		
		$this->add_control(
			'case_studies_category',
			[
				'label'       => esc_html__( 'Case Studies Category', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT2,
				'description' => esc_html__( 'Display posts from a specific category (enter case studies category slug name). Use "all" to dislay all posts. ', 'radiantthemes-addons' ),
				'options'     => $this->get_case_categories(),
				'default'     => 'all',
			]
		);
		

		$this->add_control(
			'no_of_case_studies',
			[
				'label'       => __( 'Number of Case Studies', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter number of Case Studies to display. Leave blank to show all posts.', 'radiantthemes-addons' ),
				

			]
		);
		$this->add_control(
			'case_study_box_alignment',
			[
				'label'       => esc_html__( 'Case Study Box Align', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'options'     => [
					'left'   => esc_html__( 'Left', 'radiantthemes-addons' ),
					'right'  => esc_html__( 'Right', 'radiantthemes-addons' ),
					'center' => esc_html__( 'Center', 'radiantthemes-addons' ),

				],
				'default'     => 'center',
			]
		);
		$this->add_control(
			'case_study_box_number',
			[
				'label'       => esc_html__( 'Case Study Box Number', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'options'     => [
					'2' => esc_html__( '2', 'radiantthemes-addons' ),
					'3' => esc_html__( '3', 'radiantthemes-addons' ),
					'4' => esc_html__( '4', 'radiantthemes-addons' ),

				],
				'default'     => '3',
			]
		);
		$this->add_control(
			'case_study_enable_zoom',
			[
				'label'       => esc_html__( 'Enable Zoom?', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'options'     => [
					'yes' => esc_html__( 'Yes', 'radiantthemes-addons' ),
					'no'  => esc_html__( 'No', 'radiantthemes-addons' ),

				],
				'default'     => 'no',
			]
		);
		$this->add_control(
			'case_study_enable_title',
			[
				'label'       => esc_html__( 'Case Study Enable Title?', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'options'     => [
					'yes' => esc_html__( 'Yes', 'radiantthemes-addons' ),
					'no'  => esc_html__( 'No', 'radiantthemes-addons' ),

				],
				'default'     => 'no',
			]
		);
		$this->add_control(
			'case_study_enable_excerpt',
			[
				'label'       => esc_html__( 'Case Study Enable excerpt?', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'options'     => [
					'yes' => esc_html__( 'Yes', 'radiantthemes-addons' ),
					'no'  => esc_html__( 'No', 'radiantthemes-addons' ),

				],
				'default'     => 'no',
			]
		);
		$this->add_control(
			'pricing_table_highlight',
			[
				'label'        => __( 'Enable Link Button?', 'radiantthemes-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'radiantthemes-addons' ),
				'label_off'    => __( 'Hide', 'radiantthemes-addons' ),
				'return_value' => 'yes',
				'default'      => 'no',
				'description'  => esc_html__( 'Button style can be controled from Theme Option > Button.', 'radiantthemes-addons' ),
				'condition'    => [
					'case_study_enable_zoom' => 'no',
				],
			]
		);
		$this->add_control(
			'case_study_link_button_text',
			[
				'label'       => esc_html__( 'Link Button Text', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter text for link button. E.g. Details', 'radiantthemes-addons' ),
				'condition'   => [
					'case_study_enable_link_button' => 'true',
				],
				'default'     => 'Details',

			]
		);
		$this->add_control(
			'case_study_spacing',
			[
				'label'       => esc_html__( 'Spacing between Case Study Items', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'Enter only the spacing value without unit. E.g. 30', 'radiantthemes-addons' ),
				'default'     => '0',

			]
		);
		$this->add_control(
			'case_study_date',
			[
				'label'        => esc_html__( 'Show Date?', 'radiantthemes-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', 'radiantthemes-addons' ),
				'label_off'    => esc_html__( 'Hide', 'radiantthemes-addons' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'case_study_style_variation' => 'two',
				],
			]
		);
		$this->add_control(
			'case_study_author',
			[
				'label'        => esc_html__( 'Show Author?', 'radiantthemes-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Show', 'radiantthemes-addons' ),
				'label_off'    => esc_html__( 'Hide', 'radiantthemes-addons' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'case_study_style_variation' => 'two',
				],
			]
		);
		

		$this->add_control(
			'case_study_looping_order',
			[
				'label'       => esc_html__( 'Order By', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'options'     => [
					'date'       => esc_html__( 'Date', 'radiantthemes-addons' ),
					'ID'         => esc_html__( 'ID', 'radiantthemes-addons' ),
					'title'      => esc_html__( 'Title', 'radiantthemes-addons' ),
					'modified'   => esc_html__( 'Modified', 'radiantthemes-addons' ),
					'random'     => esc_html__( 'Random', 'radiantthemes-addons' ),
					'menu_order' => esc_html__( 'Menu order', 'radiantthemes-addons' ),

				],
				'default'     => 'ID',
			]
		);
		$this->add_control(
			'case_study_looping_sort',
			[
				'label'       => esc_html__( 'Sort Order', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'options'     => [
					'ASC'  => esc_html__( 'Ascending', 'radiantthemes-addons' ),
					'DESC' => esc_html__( 'Descending', 'radiantthemes-addons' ),

				],
				'default'     => 'DESC',
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'style_section',
			[
				'label' => esc_html__( 'Style', 'radiantthemes-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'content_typography',
				'label'    => esc_html__( 'Title Typography', 'radiantthemes-addons' ),
				'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
				'selector' =>
					'{{WRAPPER}} .rt-case-study-box-item > .holder > .data > .title > a , {{WRAPPER}} .rt-case-study-box.element-two>.rt-case-study-box-item>.holder>.data>.title>a',

			]
		);

		$this->add_control(
			'case_stydy_title_color',
			[
				'label'     => esc_html__( 'Title Color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-case-study-box-item > .holder > .data > .title > a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-case-study-box.element-two>.rt-case-study-box-item>.holder>.data>.title>a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'date_typography',
				'label'    => esc_html__( 'Date Typography', 'radiantthemes-addons' ),
				'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
				'selector' =>
					'{{WRAPPER}} .rt-case-study-box.element-two > .rt-case-study-box-item > .holder > .data > .date',

			]
		);

		$this->add_control(
			'case_stydy_date_color',
			[
				'label'     => esc_html__( 'Date Color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-case-study-box.element-two > .rt-case-study-box-item > .holder > .data > .date' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'author_typography',
				'label'    => esc_html__( 'Author Typography', 'radiantthemes-addons' ),
				'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
				'selector' =>
					'{{WRAPPER}} .rt-case-study-box.element-two > .rt-case-study-box-item > .holder > .data > .post-meta >span',

			]
		);

		$this->add_control(
			'case_stydy_author_color',
			[
				'label'     => esc_html__( 'Author Color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-case-study-box.element-two > .rt-case-study-box-item > .holder > .data > .post-meta >span' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'case_stydy_button_color',
			[
				'label'     => esc_html__( 'Button Color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-case-study-box.element-two>.rt-case-study-box-item>.holder>.post-btn>.post-button>.ti-angle-right' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-case-study-box.element-two > .rt-case-study-box-item > .holder > .post-btn > .post-button:hover' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		//$hidden_filter = ( 'no' === $settings['case_study_display_filter'] ) ? 'hidden' : '';

		$enable_zoom = ( 'yes' === $settings['case_study_enable_zoom'] ) ? 'has-fancybox' : '';

		$spacing_value = ( $settings['case_study_spacing'] / 2 );

		if ( '3' == $settings['case_study_box_number'] ) {
			$case_study_item_class = 'col-lg-4 col-md-4 col-sm-4 col-xs-12';
		} elseif ( '4' == $settings['case_study_box_number'] ) {
			$case_study_item_class = 'col-lg-3 col-md-3 col-sm-3 col-xs-12';
		} elseif ( '2' == $settings['case_study_box_number'] ) {
			$case_study_item_class = 'col-lg-6 col-md-6 col-sm-6 col-xs-12';
		} else {
			$case_study_item_class = '';
		}

		require 'template/template-case-study-style-' . esc_attr( $settings['case_study_style_variation'] ) . '.php';

		echo $output;
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function _content_template() {

	}
}
