<?php
/**
 * Template for Case Study Style One
 *
 * @package Radiantthemes
 */




$output = '<div class="rt-case-study-box element-one row">';
// WP_Query arguments.
global $wp_query;

$no_of_case_studies = ( $settings['no_of_case_studies'] ? $settings['no_of_case_studies'] : -1 );
if ( 'all' == $settings['case_studies_category'] || '' == $settings['case_studies_category'] ) {
	$case_studies_category = '';
} else {
	$case_studies_category = array(
		array(
			'taxonomy' => 'case-study-category',
			'field'    => 'slug',
			'terms'    => esc_attr( $settings['case_studies_category'] ),
		),
	);
}

$args     = array(
	'post_type'      => 'case-studies',
	'posts_per_page' => esc_attr( $no_of_case_studies ),
	'orderby'        => esc_attr( $settings['case_study_looping_order'] ),
	'order'          => esc_attr( $settings['case_study_looping_sort'] ),
	'tax_query'      => $case_studies_category,
);

$my_query = null;
$my_query = new WP_Query( $args );
if ( $my_query->have_posts() ) {
	while ( $my_query->have_posts() ) :
		$my_query->the_post();
		$terms   = get_the_terms( get_the_ID(), 'case-study-category' );
		$output .= '<a href="' . get_the_permalink() . '" class="info"><div class="case-study-box ';
		if ( ! empty( $terms ) ) {
			foreach ( $terms as $term ) {
				$output .= $term->slug . ' ';
			}
		}
		$output .= $case_study_item_class . '" style="padding:' . esc_attr( $spacing_value ) . 'px;">';
    $output .= '<img src="' . get_the_post_thumbnail_url( get_the_ID(), 'full' ) . '" alt="image">';

    $output .= '<div class="mask">';
    if ( 'yes' == $settings['case_study_enable_title'] ) {
			$output .= ' <h4><a href="' . get_the_permalink() . '">' . get_the_title() . '</a></h4>';
		}
    if ( 'yes' == $settings['case_study_enable_excerpt'] ) {
			$output .= '<p class="excerpt">' . wp_trim_words( get_the_excerpt(), 10, '...' ) . '</p>';
		}
	if ( 'yes' == $settings['case_study_enable_excerpt'] ) {
			$output .= '<p>' . wp_trim_words( get_the_excerpt(), 10, '...' ) . '</p>';
		}	  
      
      $output .= '<a href="' . get_the_permalink() . '" class="info">Read More</a>
    </div>
    </div></a>';



	endwhile;
}
$output .= '</div>';
