<?php
/**
 * Template for Case Study Style Two
 *
 * @package Radiantthemes
 */




$output = '<div class="rt-case-study-box element-two row">';
// WP_Query arguments.
global $wp_query;

$no_of_case_studies = ( $settings['no_of_case_studies'] ? $settings['no_of_case_studies'] : -1 );
if ( 'all' == $settings['case_studies_category'] || '' == $settings['case_studies_category'] ) {
	$case_studies_category = '';
} else {
	$case_studies_category = array(
		array(
			'taxonomy' => 'case-study-category',
			'field'    => 'slug',
			'terms'    => esc_attr( $settings['case_studies_category'] ),
		),
	);
}

$args     = array(
	'post_type'      => 'case-studies',
	'posts_per_page' => esc_attr( $no_of_case_studies ),
	'orderby'        => esc_attr( $settings['case_study_looping_order'] ),
	'order'          => esc_attr( $settings['case_study_looping_sort'] ),
	'tax_query'      => $case_studies_category,
);

$my_query = null;
$my_query = new WP_Query( $args );
if ( $my_query->have_posts() ) {
	while ( $my_query->have_posts() ) :
		$my_query->the_post();
		$terms   = get_the_terms( get_the_ID(), 'case-study-category' );
		$output .= '<div class="rt-case-study-box-item ';
		if ( ! empty( $terms ) ) {
			foreach ( $terms as $term ) {
				$output .= $term->slug . ' ';
			}
		}
		$output .= $case_study_item_class . '" style="padding:' . esc_attr( $spacing_value ) . 'px;">';

		$output .= '<div class="holder">';

		$output .= '<div class="pic">';
		$output .= '<img src="' . plugins_url( 'radiantthemes-addons/assets/images/Blank-Image-100x70.png' ) . '" alt="' . get_the_title() . '" data-no-retina="" width="400" height="264">';
		$output .= '<a class="placeholder" href="' . get_the_permalink() . '" style="background-image:url(' . get_the_post_thumbnail_url( get_the_ID(), 'full' ) . ')"></a>';
		$output .= '</div>';

		$output .= '<div class="post-btn">';
		$output .= '<a href="' . get_the_permalink() . '" class="post-button">';
		$output .= '<span class="ti-angle-right"></span>';
		$output .= '</a>';
		$output .= '</div>';

		$output .= '<div class="data matchHeight">';
		if ( 'yes' == $settings['case_study_date'] ) {
			$output .= '<span class="date">' . get_the_date() . '</span>';
		}
		if ( 'yes' == $settings['case_study_enable_title'] ) {
			$output .= ' <h3 class="title"><a href="' . get_the_permalink() . '">' . get_the_title() . '</a></h3>';
		}
		if ( 'yes' == $settings['case_study_enable_excerpt'] ) {
			$output .= '<p class="excerpt">' . wp_trim_words( get_the_excerpt(), 10, '...' ) . '</p>';
		}
		$output .= '<div class="post-meta">';
		if ( 'yes' == $settings['case_study_author'] ) {
			$output .= '<span class="author">By ' . get_the_author() . '</span>';
		}
		$output .= '</div>';
		$output .= '</div>';

		$output .= '</div>';
		$output .= '</div>';
	endwhile;
}
$output .= '</div>';
