<?php
/**
 * Fancy Image Box Style Addon
 *
 * @package Radiantthemes
 */

namespace RadiantthemesAddons\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Control_Repeater;
use Elementor\Control_URL;
use Elementor\Widget_Base;


// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Elementor Fancy Image Box widget.
 *
 * Elementor widget that displays fancy image box.
 *
 * @since 1.0.0
 */
class Radiantthemes_Style_Fancy_Image_Box extends \Elementor\Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'radiant-fancy-image-box';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Fancy Image Box', 'radiantthemes-addons' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-image-box';
	}

	/**
	 * Requires css files.
	 *
	 * @return array
	 */
	// public function get_style_depends() {
	// 	return array(
	// 		'radiantthemes-addons-custom',
	// 	);
	// }

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'radiant-widgets-category' );
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'general_section',
			array(
				'label' => esc_html__( 'General', 'radiantthemes-addons' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'style_layout',
			array(
				'label'   => esc_html__( 'Fancy Image Box Layout', 'radiantthemes-addons' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'three',
				'options' => array(
					'one'   => esc_html__( '1 Column', 'radiantthemes-addons' ),
					'two'   => esc_html__( '2 Columns', 'radiantthemes-addons' ),
					'three' => esc_html__( '3 Columns', 'radiantthemes-addons' ),
					'four'  => esc_html__( '4 Columns', 'radiantthemes-addons' ),
					'six'   => esc_html__( '6 Columns', 'radiantthemes-addons' ),
					'equal' => esc_html__( 'Equal Columns', 'radiantthemes-addons' ),
				),
			)
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'fancy_title',
			array(
				'label'       => esc_html__( 'Title', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Fancy Title', 'radiantthemes-addons' ),
				'label_block' => true,
			)
		);

		$repeater->add_control(
			'fancy_sub_title',
			array(
				'label'       => esc_html__( 'Sub Title', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Fancy Subtitle', 'radiantthemes-addons' ),
				'label_block' => true,
			)
		);

		$repeater->add_control(
			'fancy_image',
			array(
				'label' => esc_html__( 'Choose Image', 'radiantthemes-addons' ),
				'type'  => Controls_Manager::MEDIA,
			)
		);

		$repeater->add_control(
			'fancy_description',
			array(
				'label'       => esc_html__( 'Description', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::TEXTAREA,
				'rows'        => 10,
				'default'     => esc_html__( 'Lorem Ipsum is simply dum text of the printing typesetting been the industry standard dummy text ever since.', 'radiantthemes-addons' ),
				'placeholder' => esc_html__( 'Type your description here', 'radiantthemes-addons' ),
			)
		);

		$repeater->add_control(
			'fancy_read_more_text',
			array(
				'label'       => esc_html__( 'Read More Text', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Discover More', 'radiantthemes-addons' ),
				'label_block' => true,
			)
		);

		$repeater->add_control(
			'fancy_link',
			array(
				'label'         => esc_html__( 'Read More Link', 'radiantthemes-addons' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => esc_html__( 'https://your-link.com', 'radiantthemes-addons' ),
				'show_external' => true,
				'default'       => array(
					'url'         => '#',
					'is_external' => false,
					'nofollow'    => false,
				),
			)
		);

		$this->add_control(
			'fancy_image_box_repeater',
			array(
				'label'       => esc_html__( 'Repeater Image Box', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'title_field' => '{{{ fancy_title }}}',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'fancy_overlay_image_section',
			array(
				'label' => esc_html__( 'Overlay Images', 'radiantthemes-addons' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'fancy_overlay_image_one',
			array(
				'label'   => esc_html__( 'Overlay Image One', 'radiantthemes-addons' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => plugins_url( 'radiantthemes-addons/assets/images/ovarlay-part-1.png' ),
				),
			)
		);

		$this->add_control(
			'fancy_overlay_image_two',
			array(
				'label'   => esc_html__( 'Overlay Image Two', 'radiantthemes-addons' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(
					'url' => plugins_url( 'radiantthemes-addons/assets/images/ovarlay-part-2.png' ),
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'fancy_image_color_section',
			array(
				'label' => esc_html__( 'Color', 'radiantthemes-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'fancy_image_title_color',
			array(
				'label'     => esc_html__( 'Title Color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#FFFFFF',
				'selectors' => array(
					'{{WRAPPER}} .rt-fancy-img-box.element-one .holder .box-main-content .title' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'fancy_image_subtitle_color',
			array(
				'label'     => esc_html__( 'Subtitle Color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#FFFFFF',
				'selectors' => array(
					'{{WRAPPER}} .rt-fancy-img-box.element-one .holder .box-main-content .category' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'fancy_image_content_color',
			array(
				'label'     => esc_html__( 'Content Color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000000',
				'selectors' => array(
					'{{WRAPPER}} .rt-fancy-img-box.element-one .holder .box-overlay-content .text-content' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'fancy_image_link_color',
			array(
				'label'     => esc_html__( 'Link Color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000000',
				'selectors' => array(
					'{{WRAPPER}} .rt-fancy-img-box.element-one .holder .box-overlay-content a' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'fancy_image_overlay_bg_color',
			array(
				'label'     => esc_html__( 'Overlay Background Color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#DAE0F6',
				'selectors' => array(
					'{{WRAPPER}} .rt-fancy-img-box.element-one .holder:before, .rt-fancy-img-box.element-one .holder:after' => 'background: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'fancy_image_fonts_section',
			array(
				'label' => esc_html__( 'Typography', 'radiantthemes-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'fancy_image_title_typography',
				'label'    => esc_html__( 'Title Typography', 'radiantthemes-addons' ),
				'selector' => '{{WRAPPER}} .rt-fancy-img-box.element-one .holder .box-main-content .title',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'fancy_image_subtitle_typography',
				'label'    => esc_html__( 'Subtitle Typography', 'radiantthemes-addons' ),
				'selector' => '{{WRAPPER}} .rt-fancy-img-box.element-one .holder .box-main-content .category',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'fancy_image_content_typography',
				'label'    => esc_html__( 'Content Typography', 'radiantthemes-addons' ),
				'selector' => '{{WRAPPER}} .rt-fancy-img-box.element-one .holder .box-overlay-content .text-content',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'fancy_image_link_typography',
				'label'    => esc_html__( 'Link Typography', 'radiantthemes-addons' ),
				'selector' => '{{WRAPPER}} .rt-fancy-img-box.element-one .holder .box-overlay-content a',
			)
		);

		$this->end_controls_section();
	}


	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function render() {

		$settings = $this->get_settings_for_display();

		if ( 'equal' === $settings['style_layout'] ) {
			$container_class = 'container-fluid';
			$grid_class      = 'col';
		} else {
			$container_class = 'container';
			if ( 'one' === $settings['style_layout'] ) {
				$grid_class = 'col-md-12 col-sm-12 col-xs-12';
			} elseif ( 'two' === $settings['style_layout'] ) {
				$grid_class = 'col-md-6 col-sm-6 col-xs-12';
			} elseif ( 'three' === $settings['style_layout'] ) {
				$grid_class = 'col-md-4 col-sm-6 col-xs-12';
			} elseif ( 'four' === $settings['style_layout'] ) {
				$grid_class = 'col-md-3 col-sm-6 col-xs-12';
			} else {
				$grid_class = 'col-md-2 col-sm-6 col-xs-12';
			}
		}
		?>
			<div class="<?php echo esc_attr( $container_class ); ?>">
				<div class="row">
					<?php if ( $settings['fancy_image_box_repeater'] ) : ?>
						<?php foreach ( $settings['fancy_image_box_repeater'] as $item ) : ?>
							<?php
							$target   = $item['fancy_link']['is_external'] ? ' target="_blank"' : '';
							$nofollow = $item['fancy_link']['nofollow'] ? ' rel="nofollow"' : '';
							?>
							<div class="<?php echo esc_attr( $grid_class ); ?>">
								<div class="rt-fancy-img-box element-one">
									<div class="holder">
										<div class="pic">
											<img src="<?php echo esc_url( $item['fancy_image']['url'] ); ?>" alt="Fancy Images">
										</div>
										<div class="img-overlay"></div>
										<div class="box-main-content">
											<h4 class="title"><?php echo esc_html( $item['fancy_title'] ); ?></h4>
											<p class="category"><?php echo esc_html( $item['fancy_sub_title'] ); ?></p>
										</div>
										<div class="box-overlay-content">
											<div class="box-overlay-pattern">
												<img src="<?php echo esc_url( $settings['fancy_overlay_image_one']['url'] ); ?>" class="pat-1" alt="f1">
												<img src="<?php echo esc_url( $settings['fancy_overlay_image_two']['url'] ); ?>" class="pat-2" alt="f2">
											</div>
											<p class="text-content">
												<?php echo esc_textarea( $item['fancy_description'] ); ?>
											</p>
											<a href="<?php echo esc_url( $item['fancy_link']['url'] ); ?>" <?php echo esc_attr( $target ); ?> <?php echo esc_attr( $nofollow ); ?>><?php echo esc_html( $item['fancy_read_more_text'] ); ?></a>
										</div>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					<?php endif; ?>
				</div>
			</div>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function _content_template() {

	}
}
