<?php
/**
 * Map Addon
 *
 * @package Radiantthemes
 */

namespace RadiantthemesAddons\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor Map widget.
 *
 * Elementor widget that displays tab content in various styles.
 *
 * @since 1.0.0
 */
class Radiantthemes_Style_Map extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'radiant-maps';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Map', 'radiantthemes-addons' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-map-pin';
	}

	/**
	 * Requires css files.
	 *
	 * @return array
	 */
	public function get_style_depends() {
		return [
			'radiantthemes-addons-custom',
		];
	}

	/**
	 * Requires js files.
	 *
	 * @return array
	 */
	public function get_script_depends() {
		return [
			'radiantthemes-map',
		];
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'radiant-widgets-category' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'section_maps_general',
			[
				'label' => esc_html__( 'Show multiple locations on maps using place marker', 'radiantthemes-addons' ),
			]
		);

		$this->add_control(
			'radiant_mapsstyle',
			[
				'label'       => esc_html__( 'Select Map Style', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'options'     => [
					'one'    => esc_html__( 'Style One', 'radiantthemes-addons' ),
				],
				'default'     => 'one',
			]
		);
		
		$repeater = new Repeater();
		
		$repeater->add_control(
			'maps_title',
			[
				'label'       => esc_html__( 'Location Name', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Location #1', 'radiantthemes-addons' ),
				'dynamic'     => [
					'active' => true,
				],
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'content',
			[
				'label'       => esc_html__( 'Location Content', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::WYSIWYG,
				'default'     => esc_html__( '123 Street Address', 'radiantthemes-addons' ),
				'dynamic'     => [
					'active' => true,
				],
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'width',
			[
				'label' => __( 'Position Left -- Right', 'plugin-domain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [  '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'default' => [
				//	'unit' => '%',
					'size' => 723,
				],
				//'selectors' => [
				//	'{{WRAPPER}} .rt-tooltip-box.element-one > .holder > .tooltip-btn a{{CURRENT_ITEM}}' => 'left: {{SIZE}}{{UNIT}};',
				//],
			]
		);
		$repeater->add_control(
			'height',
			[
				'label' => __( 'Position Top | Bottom', 'plugin-domain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'default' => [
					'size' => 170,
				],
				//'selectors' => [
				//	'{{WRAPPER}} .rt-tooltip-box.element-one > .holder > .tooltip-btn a{{CURRENT_ITEM}}' => 'top: {{SIZE}}{{UNIT}};',
				//],
			]
		);

		$repeater->add_control(
			'maps_id_random',
			[
				'label'   => esc_html__( 'Tab Id', 'radiantthemes-addons' ),
				'type'    => Controls_Manager::HIDDEN,
				'default' => '#' . substr( str_shuffle( '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ' ), 0, 16 ),
			]
		);

		$this->add_control(
			'rt-maps',
			[
				'label'       => esc_html__( 'Place Marker', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'maps_title'   => esc_html__( 'Location #1 ', 'radiantthemes-addons' ),
						
					],
					
				],
				'title_field' => '{{{ maps_title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_maps_style',
			[
				'label' => esc_html__( 'Style', 'radiantthemes-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'radiant_tab_color',
			[
				'label'     => esc_html__( 'Color ', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rt-tooltip-box.element-one > .holder > .tooltip-btn a' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} body .tooltip-inner' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .tooltip .tooltip-arrow:before' => 'border-top-color: {{VALUE}}',
								
				],

			]
		);

		/*$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'tab_title_typography',
				'label'    => esc_html__( 'Location Typography ', 'radiantthemes-addons' ),
				'selector' => '{{WRAPPER}} .rt-toolitp .tooltip-inner',
			]
		);*/

		

		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$output  = '';
		

		$output .= '<div id="rt-image-map">';
		//$output .= '<div class="holder">';
		//$output .= '<div class="pic">';
		$output .= '<img src="' . plugins_url( 'radiantthemes-addons/assets/images/Map.png' ) . '" class="img-fluid" alt="map">';
        // $output .= '</div>';
           // $output .= '<div class="tooltip-btn">';


		$counter = 0;

		foreach ( $settings['rt-maps'] as $index => $item ) :
			
			$tab_title = preg_replace( '/\s*/', '', $item['maps_title'] );
			//$tab_content=$item['maps_content'];
			$tab_content=$item['content'];
			
			
			$tab_title = preg_replace( '/[^A-Za-z0-9\-]/', '', $item['maps_title'] );
			//$tab_title = strtolower( $tab_title );
              $output .='<div class="rt-pin pin-down" data-xpos="'.$item['width']['size'].'" data-ypos="'.$item['height']['size'].'">  ';
			//$output .= '<a  data-container="body" class="elementor-repeater-item-' . $item['_id'] . '" href="#" data-toggle="tooltip" data-placement="top" title="' . esc_attr( $tab_title ) . '"></a>';
            $output .= '<h4>'.$tab_title.'</h4>';
            $output .=  $tab_content;
			$output .= '</div>';
		endforeach;
		

		

		$output .= '</div>';

		echo $output;
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function _content_template() {

	}
}
