<?php
/**
 * Template for Portfolio Style Sixteen
 *
 * @package RadiantThemes
 */
 $hidden_filter="";
 $count_posts = wp_count_posts( 'portfolio' )->publish;
$output  = '<div  class="rt-case-study-box-filter element-one' . esc_attr( $hidden_filter ) . '">';
$output .= '<button class="matchHeight current-menu-item" data-filter="*"><span>All Groups ('.$count_posts.')</span></button>';

$taxonomy     = 'portfolio-category';
$orderby      = 'name';
$show_count   = 0;     // 1 for yes, 0 for no
$pad_counts   = 0;     // 1 for yes, 0 for no
$hierarchical = 1;     // 1 for yes, 0 for no
$title        = '';
$empty        = 1;
$depth        = 1;

$args = array(
	'taxonomy'     => $taxonomy,
	'orderby'      => $orderby,
	'show_count'   => $show_count,
	'pad_counts'   => $pad_counts,
	'hierarchical' => $hierarchical,
	'title_li'     => $title,
	'hide_empty'   => $empty,
	'depth'        => $depth,
);
$cats = get_categories( $args );

foreach ( $cats as $cat ) {
	$term_id    = $cat->term_id;
	$ptype_name = $cat->name;
	$ptype_des  = $cat->description;
	$ptype_slug = $cat->slug;
	$term_link  = get_term_link( $cat );

	$output .= '<button class="matchHeight" data-filter=".';
	$output .= $ptype_slug;
	$output .= '"><span>';
	//$cp = new WP_Query( array( 'portfolio-category' => $ptype_name ) );
	//$count = $cp->found_posts;
	$output .= $ptype_name.' ('.$cat->count.')';
	$output .= '</span></button>';
}

$output .= '</div>';



if ( empty( $settings['radiant_portfolio_category'] ) ) {
	$portfolio_category = '';
} else {
	$portfolio_category = array(
		array(
			'taxonomy' => 'portfolio-category',
			'terms'    => $settings['radiant_portfolio_category'],
		),
	);
	$hidden_filter      = 'hidden';
}
$output .= '<div class="rt-portfolio-box element-sixteen row rt-case-study-box isotope">';
// WP_Query arguments.
global $wp_query;
$args     = array(
	'post_type'      => 'portfolio',
	'posts_per_page' => esc_attr( $settings['radiant_portfolio_max_posts'] ),
	'orderby'        => esc_attr( $settings['radiant_portfolio_looping_order'] ),
	'order'          => esc_attr( $settings['radiant_portfolio_looping_sort'] ),
	'tax_query'      => $portfolio_category,
);
$my_query = null;
$my_query = new WP_Query( $args );
if ( $my_query->have_posts() ) {
	while ( $my_query->have_posts() ) :
		$my_query->the_post();
		$terms = get_the_terms( get_the_ID(), 'portfolio-category' );

		// include file with color sanitization functions.
		if ( ! function_exists( 'sanitize_hex_color' ) ) {
			include_once ABSPATH . 'wp-includes/class-wp-customize-manager.php';
		}

		// fetch and sanitize the colors.
		$background_color = sanitize_hex_color( get_post_meta( get_the_id(), 'radiant_pc_primary_color', true ) );

		$output .= '<div class="rt-portfolio-box-item col-lg-4 col-md-4 col-sm-4 col-xs-12 ';
		if ( $terms ) {
			foreach ( $terms as $term ) {
				$output .= $term->slug . ' ';
			}
		}

		$output .= '">';
		$output .= '<div class="holder">';
		$output .= '<div class="pic"><a href="' . get_the_permalink() . '">';
		$output .= get_the_post_thumbnail( get_the_ID(), 'full' );
		$output .= '</a></div>';
		$output .= '</div>';
		
		 $output .= '<div class="rt-portfolio-item-details">
                   <h5 class="rt-portfolio-item-headline rt-title"><a href="' . get_the_permalink() . '">' . get_the_title() . '</a></h5>
          <div class="rt-category-holder">';

           
            $cats    = get_the_terms( get_the_ID(), 'portfolio-category' );
		if (is_array($cats) || is_object($cats))
{
		foreach ( $cats as $cat ) {
			$term_id    = $cat->term_id;
			$ptype_name = $cat->name;
			$ptype_des  = $cat->description;
			$ptype_slug = $cat->slug;
			$term_link  = get_term_link( $cat );
			$output    .= '<span class="rt-category ">';
			$output    .= $ptype_name;
			$output    .= '</span>';
		}}
           $output .= '</div>

 

          <div class="rt-show-project">
            <div class="rt-show-project-link">
              <a href="' . get_the_permalink() . '">
                Show project </a>
            </div>
          </div>
        </div>';


		/*$output .= '<div class="data">';
		$output .= '<h5 class="title"><a href="' . get_the_permalink() . '">' . get_the_title() . '</a></h5>';
		$output .= '<div class="categories">';
						$cats    = get_the_terms( get_the_ID(), 'portfolio-category' );
		if (is_array($cats) || is_object($cats))
{
		foreach ( $cats as $cat ) {
			$term_id    = $cat->term_id;
			$ptype_name = $cat->name;
			$ptype_des  = $cat->description;
			$ptype_slug = $cat->slug;
			$term_link  = get_term_link( $cat );
			$output    .= '<span>';
			$output    .= $ptype_name;
			$output    .= '</span>';
		}}
						$output .= '</div>';
		$output .= '</div>';*/
		


		$output .= '</div>';

	endwhile;
}
$output .= '</div>';



