<?php
namespace RadiantthemesAddons\Widgets;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

/**
 * @since 1.1.0
 */
class Radiantthemes_Style_Team extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'radiant-team';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Team', 'radiantthemes-addons' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-person';
	}

	/**
	 * Requires css files.
	 *
	 * @return array
	 */
	public function get_style_depends() {
		return [
			'radiantthemes-addons-custom',
		];
	}

	/**
	 * Requires js files.
	 *
	 * @return array
	 */
	public function get_script_depends() {
		return [
			'radiantthemes-team',
		];
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.1.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'radiant-widgets-category' ];
	}

	/**
	 * Get all team Custom Post Type Categories.
	 *
	 * @return array team categories.
	 */
	public function get_team_categories() {
		$team_terms = get_terms(
			array(
				'taxonomy'   => 'profession',
				'hide_empty' => false,
			)
		);

		$team_category_array = array();
		$team_category_array = array( 'all' => 'Show all Professions' );
		if ( ! empty( $team_terms ) ) {
			foreach ( $team_terms as $team_term ) {
				$team_category_array[ $team_term->slug ] = $team_term->name;
			}
		}

		return $team_category_array;
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function _register_controls() {

		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'radiantthemes-addons' ),
			]
		);

		$this->add_control(
			'style_variation',
			[
				'label'       => esc_html__( 'Team Style', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT2,
				'options'     => [
					'eight'   => esc_html__( 'Style One ', 'radiantthemes-addons' ),
					'two'   => esc_html__( 'Style Two ', 'radiantthemes-addons' ),
					'three'   => esc_html__( 'Style Three ', 'radiantthemes-addons' ),
					'four'   => esc_html__( 'Style Four ', 'radiantthemes-addons' ),
					
				],
				'default'     => 'eight',
			]
		);

		$this->add_control(
			'team_category',
			[
				'label'       => esc_html__( 'Select Professions', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT2,
				'options'     => $this->get_team_categories(),
				'default'     => 'all','multiple'    => true,
			]
		);

		$this->add_control(
			'team_allow_carousel',
			[
				'label'   => esc_html__( 'Carousel', 'radiantthemes-addons' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'false' => esc_html__( 'No', 'radiantthemes-addons' ),
					'true'  => esc_html__( 'Yes', 'radiantthemes-addons' ),
				],
				'default' => 'true',
			]
		);

		/*$this->add_control(
			'allow_nav',
			[
				'label'     => esc_html__( 'Allow Navigation?', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'false' => esc_html__( 'No', 'radiantthemes-addons' ),
					'true'  => esc_html__( 'Yes', 'radiantthemes-addons' ),
				],
				'default'   => 'true',
				'condition' => [
					'team_allow_carousel' => 'true',
				],
			]
		);*/

		/*$this->add_control(
			'navigation_style',
			[
				'label'       => esc_html__( 'Navigation Style', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT2,
				'options'     => [
					'one'   => esc_html__( 'Style One (Arrow - Light)', 'radiantthemes-addons' ),
					'two'   => esc_html__( 'Style Two (Circle)', 'radiantthemes-addons' ),
					'three' => esc_html__( 'Style Three (Arrow - Dark)', 'radiantthemes-addons' ),
				],
				'default'     => 'one',
				'condition'   => [
					'allow_nav'                   => 'true',
					'team_allow_carousel!' => 'false',
				],
			]
		);*/

		$this->add_control(
			'allow_dots',
			[
				'label'       => esc_html__( 'Allow Dots for Navigation?', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT,
				'options'     => [
					'false' => esc_html__( 'No', 'radiantthemes-addons' ),
					'true'  => esc_html__( 'Yes', 'radiantthemes-addons' ),
				],
				'default'     => 'true',
				'condition'   => [
					'team_allow_carousel' => 'true',
				],
			]
		);


		$this->add_control(
			'order',
			[
				'label'       => esc_html__( 'Order', 'radiantthemes-addons' ),
				'label_block' => false,
				'type'        => Controls_Manager::SELECT,
				'options'     => [
					'ASC'  => esc_html__( 'Ascending', 'radiantthemes-addons' ),
					'DESC' => esc_html__( 'Descending', 'radiantthemes-addons' ),
				],
				'default'     => 'DESC',
			]
		);

		$this->add_control(
			'order_by',
			[
				'label'       => esc_html__( 'Order By', 'radiantthemes-addons' ),
				'label_block' => true,
				'type'        => Controls_Manager::SELECT2,
				'options'     => [
					'date'     => esc_html__( 'Date', 'radiantthemes-addons' ),
					'title'    => esc_html__( 'Title', 'radiantthemes-addons' ),
					'ID'       => esc_html__( 'ID', 'radiantthemes-addons' ),
					'rand'     => esc_html__( 'Random', 'radiantthemes-addons' ),
					'modified' => esc_html__( 'Last Modified', 'radiantthemes-addons' ),
				],
				'default'     => 'date',
			]
		);

		$this->add_control(
			'max_posts',
			[
				'label'       => esc_html__( 'Count', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::NUMBER,
				'min'         => -1,
				'description' => esc_html__( 'Number of posts to show ( -1 for all posts )', 'radiantthemes-addons' ),
				'default'     => 4,
			]
		);

		$this->add_control(
			'posts_in_desktop',
			[
				'label'       => esc_html__( 'Number of Posts on Desktop', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::NUMBER,
				'description' => esc_html__( 'Posts on Desktop', 'radiantthemes-addons' ),
				'condition'   => [
					'team_allow_carousel' => 'true',
				],
				'default'     => 3,
			]
		);

		$this->add_control(
			'posts_in_tab',
			[
				'label'       => esc_html__( 'Number of Posts on Tab', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::NUMBER,
				'description' => esc_html__( 'Posts on Tab', 'radiantthemes-addons' ),
				'condition'   => [
					'team_allow_carousel' => 'true',
				],
				'default'     => 2,
			]
		);

		$this->add_control(
			'posts_in_mobile',
			[
				'label'       => esc_html__( 'Number of Posts on Mobile', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::NUMBER,
				'description' => esc_html__( 'Posts on Mobile', 'radiantthemes-addons' ),
				'condition'   => [
					'team_allow_carousel' => 'true',
				],
				'default'     => 1,
			]
		);
		$this->add_control(
			'space_between_posts',
			[
				'label'       => esc_html__( 'Space beteen posts', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::NUMBER,
				'description' => esc_html__( 'Space between Two Posts', 'radiantthemes-addons' ),
				'condition'   => [
					'team_allow_carousel' => 'true',
				],
				'default'     => 30,
			]
		);

		$this->add_control(
			'team_no_row_items',
			[
				'label'       => esc_html__( 'Number of Row Items', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::NUMBER,
				'description' => esc_html__( 'Select number of items you want to see in a row', 'radiantthemes-addons' ),
				'condition'   => [
					'team_allow_carousel' => 'false',
				],
				'default'     => 2,
			]
		);

		$this->add_control(
			'team_enable_link',
			[
				'label'   => __( 'Enable Link?', 'radiantthemes-addons' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'true'  => esc_html__( 'Yes', 'radiantthemes-addons' ),
					'false' => esc_html__( 'No', 'radiantthemes-addons' ),

				],
				'default' => 'true',

			]
		);
		$this->add_control(
			'team_button_text',
			[
				'label'       => esc_html__( 'Button Text', 'radiantthemes-addons' ),
				'type'        => Controls_Manager::TEXT,
				'condition'   => [
					'team_enable_link' => 'true',
				],
				'default'     => 'Read More',
			]
		);

		
	

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_team_general',
			[
				'label' => __( 'General', 'radiantthemes-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'team_color',
			[
				'label'     => esc_html__( 'Color Scheme', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'scheme' => [
					'type'  => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .team.element-one .team-item > .holder > .data .designation,
					.team.element-one .team-four > .holder > .data .designation' => 'color: {{VALUE}}',

					'{{WRAPPER}} .team.element-three .rt-doctor:hover .box-content' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .team.element-four .rt-professionals:hover .box-content' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .team.element-eight .team-item .holder .team-content' => 'background-color: {{VALUE}}',

				],
				'default'   => '#000000',
			]
		);

		
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__( 'Button Typography', 'radiantthemes-addons' ),
				'name'     => 'button_typography',
				'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
				'selector' => '{{WRAPPER}} .team.element-two .rt-doctor .box-content a , .team.element-three .rt-doctor:hover .box-content .view_btn, .team.element-three .rt-doctor:hover .box-content .view_btn.view_btn-simple,.team.element-four .rt-professionals:hover .box-content .view_btn.view_btn-simple',
				'condition'   => [
					'team_enable_link' => 'true',
				],
			]
		);
		$this->add_control(
			'team_button_color',
			[
				'label'     => esc_html__( 'Button color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'scheme' => [
					'type'  => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .team.element-two .rt-doctor .box-content a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team.element-three .rt-doctor:hover .box-content .view_btn.view_btn-simple:after,
.team.element-three .rt-doctor:hover .box-content .view_btn.view_btn-simple:before' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .team.element-three .rt-doctor:hover .box-content .view_btn.view_btn-simple' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team.element-four .rt-professionals:hover .box-content .view_btn.view_btn-simple' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team.element-three .rt-professionals:hover .box-content .view_btn.view_btn-simple:after,
.team.element-three .rt-professionals:hover .box-content .view_btn.view_btn-simple:before' => 'background-color: {{VALUE}}',
					
					
				],
				'condition'   => [
					'team_enable_link' => 'true',
				],
				
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_team_content',
			[
				'label' => __( 'Content', 'radiantthemes-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__( 'Content Typography', 'radiantthemes-addons' ),
				'name'     => 'content_typography',
				'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
				'selector' => '{{WRAPPER}} .team .team-item > .holder > .team-data blockquote p , .team.element-two .rt-doctor .box-content p , .team.element-three .rt-doctor .box-content p , .team.element-four .rt-professionals .box-content p',
			]
		);
		$this->add_control(
			'team_content_color',
			[
				'label'     => esc_html__( 'Content color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'scheme' => [
					'type'  => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .team.element-one .team-item > .holder > .data .title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team.element-two .rt-doctor .box-content p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team.element-three .rt-doctor .box-content p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team.element-four .rt-professionals .box-content p' => 'color: {{VALUE}}',
					
					

				],
				
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_team_title',
			[
				'label' => esc_html__( 'Title', 'radiantthemes-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__( 'Title Typography', 'radiantthemes-addons' ),
				'name'     => 'title_typography',
				'scheme'   => Scheme_Typography::TYPOGRAPHY_1,
				'selector' => 
				'{{WRAPPER}} .team .team-item > .holder > .team-title .title, .team.element-five .rt_team_detail_bx h3, .team.element-seven .rt_team_detail_bx h3 , .team.element-one .team-item > .holder > .data .title , .team.element-eight .team-item .holder .team-content .team-title ,.team.element-two .rt-doctor .box-content h4 , .team.element-three h3, .team.element-four h4',
				
				
				
				
			]
		);
		$this->add_control(
			'team_time_color',
			[
				'label'     => esc_html__( 'Title color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'scheme' => [
					'type'  => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .team.element-one .team-item > .holder > .data .title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team.element-seven .rt_team_detail_bx h3' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team.element-three h3' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team.element-eight .team-item .holder .team-content .team-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team.element-two .rt-doctor .box-content h4' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team.element-four h4' => 'color: {{VALUE}}',
					

					

				],
				
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_team_designation',
			[
				'label' => esc_html__( 'Designation', 'radiantthemes-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'    => esc_html__( 'Designation Typography', 'radiantthemes-addons' ),
				'name'     => 'designation_typography',
				'scheme'   => Scheme_Typography::TYPOGRAPHY_3,
				'selector' => 
				    '{{WRAPPER}} .team.element-eight .team-item .holder .team-content .team-role , .team.element-two .rt-doctor .box-content .post , .team.element-three h4 ,.team.element-four h6 ',
				    
			]
		);
		$this->add_control(
			'team_designation_color',
			[
				'label'     => esc_html__( 'Designation color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'scheme' => [
					'type'  => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .team.element-two .rt-doctor .box-content .post' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team.element-eight .team-item .holder .team-content .team-role' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team.element-three h4' => 'color: {{VALUE}}',
					'{{WRAPPER}}  .team.element-four h6' => 'color: {{VALUE}}',
					

				],
				
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_dot',
			[
				'label' => esc_html__( 'Dots', 'radiantthemes-addons' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'allow_dots' => 'true',
				],
			]
			
		);
		$this->add_control(
			'team_dots_color',
			[
				'label'     => esc_html__( 'Dots color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'scheme' => [
					'type'  => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_1,
				],
				'condition'   => [
					'allow_dots' => 'true',
				],
				'selectors' => [
					
					'{{WRAPPER}}  .swiper-container-horizontal > .swiper-pagination-bullets .swiper-pagination-bullet

 ' => 'background: {{VALUE}}',
					

				],
				
			]
		);
		$this->add_control(
			'team_dots_acolor',
			[
				'label'     => esc_html__( 'Dots active color', 'radiantthemes-addons' ),
				'type'      => Controls_Manager::COLOR,
				'scheme' => [
					'type'  => Scheme_Color::get_type(),
					'value' => Scheme_Color::COLOR_1,
				],
				'condition'   => [
					'allow_dots' => 'true',
				],
				'selectors' => [
					
					'{{WRAPPER}} .swiper-container-horizontal > .swiper-pagination-bullets .swiper-pagination-bullet-active' => 'background: {{VALUE}}',
					

				],
				
			]
		);



        
		$this->end_controls_section();
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */

	protected function render() {
		$settings = $this->get_settings_for_display();

		//$navigation_style = $settings['allow_nav'] ? 'owl-nav-style-' . esc_attr( $settings['navigation_style'] ) : '';
		//$dot_style        = $settings['allow_dots'] ? 'owl-dot-style-' . esc_attr( $settings['navigation_dot_style'] ) : '';

		//$team_id = $settings['extra_id'] ? 'id="' . esc_attr( $settings['extra_id'] ) . '"' : '';
		$output = "\r" . '<!-- team -->' . "\r";

						$time="";
						

		if ( 'false' == $settings['team_allow_carousel'] ) {
				$output .= '<div class="row team element-' . $settings['style_variation'] . ' ';
				//$output .= ' ' . $settings['extra_class'] . '"  ' . $team_id;
				$output .= ' data-row-items="';
				$output .= esc_attr( $settings['team_no_row_items'] ) . '"';
				$output .= '>';
			
			} elseif ( 'true' == $settings['team_allow_carousel'] ) {
				//$output .= '<div class="team swiper-container element-' . $settings['style_variation'] . '  ';
				$output .= '<div class="team swiper-container element-' . $settings['style_variation'] . '" data-mobile-items="'.$settings['posts_in_mobile'] . '" data-tab-items="'.$settings['posts_in_tab'] . '" data-desktop-items="'.$settings['posts_in_desktop'] . '" data-spacer="'.$settings['space_between_posts'] . '">';
				$output .= ' <div class="swiper-wrapper">';
			} else {
				$output .= '';
			}
			if ( empty( $settings['max_posts'] ) ) {
			$settings['max_posts'] = -1;
		}
			$count=0;
            if($settings['team_category'] && 'all' != $settings['team_category']){
	    	$count=count($settings['team_category']);}
			for($i=0;$i<$count;$i++)
            {	
                $c[] =  $settings['team_category'][$i] ;
            }
            
			if ( 'all' == $settings['team_category'] || '' == $settings['team_category'] ) {
			    $team_category = '';
			} else {
			    $team_category = array(
			        array(
			            'taxonomy' => 'profession',
			            'field'    => 'slug',
			            'terms'    => $c,
			        ),
			    );
			    $hidden_filter      = 'hidden';
			}
			$query = new \WP_Query(
				array(
					'post_type'      => 'team',
					'posts_per_page' => $settings['max_posts'],
					'order'          => $settings['order'],
					'orderby'        => $settings['order_by'],
					'tax_query'      => $team_category,
				)
			);




		

		$data  = 0;
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();
					require 'template/template-team-item-' . $settings['style_variation'] . '.php';
				}
				wp_reset_postdata();
			} else {
				$output .= wp_kses_post('<p>No items found</p>', 'radiantthemes-addons' );
			}
			if ( 'true' === $settings['team_allow_carousel'] ) {
		$output .= '</div>';
		if ( 'true' === $settings['allow_dots'] ) {
		
		$output .= '<div class="swiper-pagination-team"></div>';
		}
}

			$output .= '</div>' . "\r";
			$output .= '<!-- team -->' . "\r";
			echo $output;
		?>
		<?php
	}

	/**
	 * Render the widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.1.0
	 *
	 * @access protected
	 */
	protected function _content_template() {

	}
}